/*
  Goal explosion when scoring. 
  Author Mark Caldwell aka W@rHe@d of The Reliquary
  
  A nice explosion fanfare makes scoring more satisfying and keeps with the theme of the game, which is Bombing Run,
  wherein the goal is to blow up the enemy base. In prior ut's BR, this idea was not really clearly brought forth, 
  and one would wonder why it was even called Bombing Run in the first place.
  
  Note: can not spawn the explosions directly from the UTBRGoal class because ut won't allow a SetTimer() call
  in the goal class, because it says it's a bstatic actor (because it's placed via the map editor).   
  Better to have this code in a separate class anyway.
*/

class UTBRGoalExplosion extends Actor;

var float ExplosionDuration;
var float ExplosionElaspedTime;
var float TimerDuration;
var class<Actor> ExplosionEffect;
var SoundCue ExplosionSound;


function PostBeginPlay()
{
    super.PostBeginPlay();
	
    Startup();
}

function Startup()
{
	TimerDuration = 0.20;
	
	ExplosionDuration = 2;
	
	//if game has ended then we trigger a greater fanfare then just regular scoring
	if (WorldInfo.Game.bGameEnded)
	{
	   ExplosionDuration = 5;
	}
	
	ExplosionElaspedTime = 0;
			
	SetTimer(TimerDuration, true, 'ExplosionTimer');	
}

function ExplosionTimer()
{
    if (ExplosionElaspedTime > ExplosionDuration)	
    {
	    ClearTimer('ExplosionTimer');
	    destroy();
	    
	    return;
    }	
	
    if (WorldInfo.Game.bGameEnded)
    {
	    MakeExplosion(400);
	    
	    //usually endgame focus will be real tight around the goal, so make explosions
	    //the players will definitly see
	    MakeExplosion(100);
    }
    else
    {
	    MakeExplosion(200);
    }
    
	ExplosionElaspedTime = ExplosionElaspedTime + TimerDuration;    
}

function MakeExplosion(int dist)
{
    local vector ExplosionVect;	
    	
    ExplosionVect = vect(0, 0, 0);
    ExplosionVect.x = rand(dist * 2) - dist;
    ExplosionVect.y = rand(dist * 2) - dist;
    ExplosionVect.z = rand(dist * 2) - dist;    

    Spawn(class'UTBRExplosion',,,Location + ExplosionVect);       
}

defaultproperties
{
   Name="Default__UTBRGoalExplosion"
   ObjectArchetype=Actor'Engine.Default__Actor'
}
